<?php
session_start();
include 'includes/auth.php';
include 'includes/db.php';

// Search filter
$search = mysqli_real_escape_string($conn, $_GET['search'] ?? '');
$search_filter = '';
if (!empty($search)) {
    $search_filter = " AND (
        CONCAT(m.first_name, ' ', m.surname) LIKE '%$search%' OR 
        m.phone LIKE '%$search%' OR 
        m.nfc_uid LIKE '%$search%'
    )";
}

// Pagination
$limit = 10;
$page = max(1, (int)($_GET['page'] ?? 1));
$offset = ($page - 1) * $limit;

// Count total banned (manual or 3+ warnings)
$count_sql = "
  SELECT COUNT(*) AS total FROM (
    SELECT m.id
    FROM members m
    LEFT JOIN warnings w ON w.member_id = m.id
    GROUP BY m.id
    HAVING COUNT(w.id) >= 3 OR MAX(m.banned) = 1
  ) AS banned_members
";
$total = mysqli_fetch_assoc(mysqli_query($conn, $count_sql))['total'];
$total_pages = ceil($total / $limit);

// Fetch banned members
$sql = "
  SELECT m.*, COUNT(w.id) AS warnings_count
  FROM members m
  LEFT JOIN warnings w ON w.member_id = m.id
  GROUP BY m.id
  HAVING warnings_count >= 3 OR m.banned = 1
  $search_filter
  ORDER BY m.id DESC
  LIMIT $offset, $limit
";
$result = mysqli_query($conn, $sql);

include 'includes/header.php';
?>

<h2>Banned Members</h2>

<form class="row mb-3" method="get">
  <div class="col-md-4">
    <input type="text" name="search" class="form-control" placeholder="Search name, phone, NFC UID" value="<?= htmlspecialchars($_GET['search'] ?? '') ?>">
  </div>
  <div class="col-md-2">
    <button class="btn btn-primary w-100"><i class="fas fa-search"></i> Search</button>
  </div>
</form>

<div class="table-responsive">
  <table class="table table-bordered table-hover align-middle">
    <thead class="table-dark">
      <tr>
        <th>ID</th>
        <th>Name</th>
        <th>Phone</th>
        <th>NFC UID</th>
        <th>Membership</th>
        <th>Expiry</th>
        <th>Status</th>
        <th>Warnings</th>
        <th>Actions</th>
      </tr>
    </thead>
    <tbody>
    <?php while ($row = mysqli_fetch_assoc($result)):
      $expiry = (!empty($row['expiry_date']) && $row['expiry_date'] !== '0000-00-00')
        ? date('d M Y', strtotime($row['expiry_date']))
        : '—';
    ?>
      <tr>
        <td><?= $row['id'] ?></td>
        <td><?= htmlspecialchars($row['first_name'] . ' ' . $row['surname']) ?></td>
        <td><?= htmlspecialchars($row['phone']) ?></td>
        <td><?= htmlspecialchars($row['nfc_uid'] ?: '—') ?></td>
        <td><?= htmlspecialchars($row['membership_type'] ?: '—') ?></td>
        <td><?= $expiry ?></td>
        <td><?= htmlspecialchars($row['payment_status']) ?></td>
        <td><span class="badge bg-danger"><?= $row['warnings_count'] ?> Warnings</span></td>
        <td>
          <a href="edit_member.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
          <form method="POST" action="unban_member.php" style="display:inline;" onsubmit="return confirm('Unban this member?');">
            <input type="hidden" name="member_id" value="<?= $row['id'] ?>">
            <button class="btn btn-sm btn-success">Unban</button>
          </form>
        </td>
      </tr>
    <?php endwhile; ?>
    </tbody>
  </table>
</div>

<!-- Pagination -->
<nav>
  <ul class="pagination">
    <?php if ($page > 1): ?>
      <li class="page-item"><a class="page-link" href="?search=<?= urlencode($search) ?>&page=<?= $page-1 ?>">Previous</a></li>
    <?php endif; ?>
    <?php for ($i = 1; $i <= $total_pages; $i++): ?>
      <li class="page-item <?= $i === $page ? 'active' : '' ?>">
        <a class="page-link" href="?search=<?= urlencode($search) ?>&page=<?= $i ?>"><?= $i ?></a>
      </li>
    <?php endfor; ?>
    <?php if ($page < $total_pages): ?>
      <li class="page-item"><a class="page-link" href="?search=<?= urlencode($search) ?>&page=<?= $page+1 ?>">Next</a></li>
    <?php endif; ?>
  </ul>
</nav>

<?php include 'includes/footer.php'; ?>
